/*
 * Decompiled with CFR 0.152.
 */
package xortroll.goldleaf.quark.usb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Optional;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import xortroll.goldleaf.quark.Logging;
import xortroll.goldleaf.quark.Version;

public class USBInterface {
    public static final short VendorId = 1406;
    public static final short ProductId = 12288;
    public static final byte WriteEndpoint = 1;
    public static final byte ReadEndpoint = -127;
    private int interface_no;
    private Context context;
    private Device device;
    private DeviceHandle device_handle;
    private boolean is_dev_version;
    private Version product_version;

    private USBInterface(int interface_no) {
        this.interface_no = interface_no;
        this.context = new Context();
        this.device_handle = null;
        this.device = null;
    }

    public boolean isDevVersion() {
        return this.is_dev_version;
    }

    public Version getProductVersion() {
        return this.product_version;
    }

    private synchronized boolean readImpl(ByteBuffer buf, int size) {
        IntBuffer out_read_size_buf = IntBuffer.allocate(1);
        int res = LibUsb.bulkTransfer(this.device_handle, (byte)-127, buf, out_read_size_buf, 0L);
        int out_read_size = out_read_size_buf.get(0);
        return res == 0 && out_read_size == size;
    }

    private synchronized boolean writeImpl(ByteBuffer buf, int size) {
        IntBuffer out_write_size_buf = IntBuffer.allocate(1);
        int res = LibUsb.bulkTransfer(this.device_handle, (byte)1, buf, out_write_size_buf, 0L);
        int out_write_size = out_write_size_buf.get(0);
        return res == 0 && out_write_size == size;
    }

    public byte[] readBytes(int length) {
        ByteBuffer buf = ByteBuffer.allocateDirect(length);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        this.readImpl(buf, length);
        byte[] data = new byte[length];
        buf.get(data);
        return data;
    }

    public boolean writeBytes(byte[] data) {
        ByteBuffer buf = ByteBuffer.allocateDirect(data.length);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put(data);
        return this.writeImpl(buf, data.length);
    }

    public static Optional<USBInterface> createInterface(int interface_no) {
        DeviceList devices;
        int device_count;
        USBInterface intf = new USBInterface(interface_no);
        int res = LibUsb.init(intf.context);
        if (res == 0 && (device_count = LibUsb.getDeviceList(intf.context, devices = new DeviceList())) > 0) {
            for (Device dev : devices) {
                DeviceDescriptor device_desc;
                res = LibUsb.getDeviceDescriptor(dev, device_desc = new DeviceDescriptor());
                if (res != 0 || device_desc.idVendor() != 1406 || device_desc.idProduct() != 12288) continue;
                intf.device = dev;
                break;
            }
            if (intf.device != null) {
                intf.device_handle = new DeviceHandle();
                res = LibUsb.open(intf.device, intf.device_handle);
                if (res == 0) {
                    LibUsb.freeDeviceList(devices, true);
                    res = LibUsb.setConfiguration(intf.device_handle, 1);
                    if (res == 0) {
                        intf.is_dev_version = false;
                        intf.product_version = null;
                        DeviceDescriptor device_desc = new DeviceDescriptor();
                        res = LibUsb.getDeviceDescriptor(intf.device, device_desc);
                        if (res == 0) {
                            String product = LibUsb.getStringDescriptor(intf.device_handle, device_desc.iProduct());
                            Logging.log("USB Product: '" + product + "'");
                            if (product.contains("Goldleaf")) {
                                String serial_no = LibUsb.getStringDescriptor(intf.device_handle, device_desc.iSerialNumber());
                                Logging.log("USB Serial number: '" + serial_no + "'");
                                if (serial_no.endsWith("-dev")) {
                                    intf.is_dev_version = true;
                                    serial_no = serial_no.substring(0, serial_no.length() - 4);
                                }
                                try {
                                    String[] version_tokens = serial_no.split("[.]");
                                    if (version_tokens.length >= 2) {
                                        int major = Integer.parseInt(version_tokens[0]);
                                        int minor = Integer.parseInt(version_tokens[1]);
                                        int micro = 0;
                                        if (version_tokens.length >= 3) {
                                            micro = Integer.parseInt(version_tokens[2]);
                                        }
                                        intf.product_version = new Version(major, minor, micro);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if ((res = LibUsb.claimInterface(intf.device_handle, intf.interface_no)) == 0) {
                            return Optional.of(intf);
                        }
                    }
                }
            }
        }
        return Optional.empty();
    }

    public void finalize() {
        if (this.device_handle != null) {
            LibUsb.releaseInterface(this.device_handle, this.interface_no);
            LibUsb.close(this.device_handle);
            LibUsb.exit(this.context);
            this.device_handle = null;
        }
    }
}

